// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : text.h
// Date           : February 2008
//
// Description    : This file defines the Text class used for creating text
//                  within an application.  Each text instance has its own
//                  D3DXFONT member to allow for more flexibility with defining
//                  the font style for each string.
//
//                  Init() must be called at the beginning of the main program
//                  to ensure the default font name is specified.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once



#include <vector>
#include <d3dx9.h>



#define MAX_TEXT_LEN    100



class Text 
{

  protected:


    static LPDIRECT3DDEVICE9   pD3DDevice;
    static char fontName[30];
    static std::vector<Text*> allText;


    int x;
    int y;
    int w;
    int h;
    DWORD alignment;
    DWORD                     m_Color;

    std::string               m_Text;

    LPD3DXFONT pFont;
    bool isHidden;



    void render();


  public:

    Text( int xVal, int yVal, int wVal, int hVal, const char* str, int size, int weight, bool italics, int alignVal = DT_LEFT, int colorVal = 0xFFFFFFFF );
    ~Text();

    void                      SetPosition( int xVal, int yVal );
    void                      Move( int xVal, int yVal );
    void                      SetText( const char* str, ... );
    void                      Unhide();
    void                      Hide();
    void                      SetColor( const DWORD Color );

    static void               Init( LPDIRECT3DDEVICE9 d3ddev, char* font );
    static void               RenderAll();
    static void               ReacquireDevice();
    static void               ResetDevice();

};
